/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.widget;

import io.github.cottonmc.cotton.gui.client.BackgroundPainter;
import io.github.cottonmc.cotton.gui.client.ScreenDrawing;
import io.github.cottonmc.cotton.gui.impl.LibGuiCommon;
import io.github.cottonmc.cotton.gui.widget.WAbstractSlider;
import io.github.cottonmc.cotton.gui.widget.data.Axis;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import org.jetbrains.annotations.Nullable;

public class WSlider
extends WAbstractSlider {
    public static final int TRACK_WIDTH = 6;
    public static final int THUMB_SIZE = 8;
    public static final class_2960 LIGHT_TEXTURE = LibGuiCommon.id("textures/widget/slider_light.png");
    public static final class_2960 DARK_TEXTURE = LibGuiCommon.id("textures/widget/slider_dark.png");
    @Environment(value=EnvType.CLIENT)
    @Nullable
    private BackgroundPainter backgroundPainter;

    public WSlider(int min, int max, Axis axis) {
        super(min, max, axis);
    }

    @Override
    protected int getThumbWidth() {
        return 8;
    }

    @Override
    protected boolean isMouseInsideBounds(int x, int y) {
        int ao = this.axis == Axis.HORIZONTAL ? y : x;
        int aoCenter = (this.axis == Axis.HORIZONTAL ? this.height : this.width) / 2;
        return ao >= aoCenter - 3 - 2 && ao <= aoCenter + 3 + 2;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void paint(class_332 context, int x, int y, int mouseX, int mouseY) {
        if (this.backgroundPainter != null) {
            this.backgroundPainter.paintBackground(context, x, y, this);
        } else {
            int thumbXOffset;
            int thumbY;
            int thumbX;
            class_2960 texture;
            float px = 0.03125f;
            class_2960 class_29602 = texture = this.shouldRenderInDarkMode() ? DARK_TEXTURE : LIGHT_TEXTURE;
            if (this.axis == Axis.VERTICAL) {
                int trackX = x + this.width / 2 - 3;
                thumbX = this.width / 2 - 4;
                thumbY = this.direction == WAbstractSlider.Direction.UP ? this.height - 8 + 1 - (int)(this.coordToValueRatio * (float)(this.value - this.min)) : Math.round(this.coordToValueRatio * (float)(this.value - this.min));
                thumbXOffset = 0;
                ScreenDrawing.texturedRect(context, trackX, y + 1, 6, 1, texture, 16.0f * px, 0.0f * px, 22.0f * px, 1.0f * px, -1);
                ScreenDrawing.texturedRect(context, trackX, y + 2, 6, this.height - 2, texture, 16.0f * px, 1.0f * px, 22.0f * px, 2.0f * px, -1);
                ScreenDrawing.texturedRect(context, trackX, y + this.height, 6, 1, texture, 16.0f * px, 2.0f * px, 22.0f * px, 3.0f * px, -1);
            } else {
                int trackY = y + this.height / 2 - 3;
                thumbX = this.direction == WAbstractSlider.Direction.LEFT ? this.width - 8 - (int)(this.coordToValueRatio * (float)(this.value - this.min)) : Math.round(this.coordToValueRatio * (float)(this.value - this.min));
                thumbY = this.height / 2 - 4;
                thumbXOffset = 8;
                ScreenDrawing.texturedRect(context, x, trackY, 1, 6, texture, 16.0f * px, 3.0f * px, 17.0f * px, 9.0f * px, -1);
                ScreenDrawing.texturedRect(context, x + 1, trackY, this.width - 2, 6, texture, 17.0f * px, 3.0f * px, 18.0f * px, 9.0f * px, -1);
                ScreenDrawing.texturedRect(context, x + this.width - 1, trackY, 1, 6, texture, 18.0f * px, 3.0f * px, 19.0f * px, 9.0f * px, -1);
            }
            int thumbState = this.dragging ? 1 : (mouseX >= thumbX && mouseX <= thumbX + 8 && mouseY >= thumbY && mouseY <= thumbY + 8 ? 2 : 0);
            ScreenDrawing.texturedRect(context, x + thumbX, y + thumbY, 8, 8, texture, (float)thumbXOffset * px, 0.0f * px + (float)(thumbState * 8) * px, (float)(thumbXOffset + 8) * px, 8.0f * px + (float)(thumbState * 8) * px, -1);
            if (thumbState == 0 && this.isFocused()) {
                ScreenDrawing.texturedRect(context, x + thumbX, y + thumbY, 8, 8, texture, 0.0f * px, 24.0f * px, 8.0f * px, 32.0f * px, -1);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    @Nullable
    public BackgroundPainter getBackgroundPainter() {
        return this.backgroundPainter;
    }

    @Environment(value=EnvType.CLIENT)
    public void setBackgroundPainter(@Nullable BackgroundPainter backgroundPainter) {
        this.backgroundPainter = backgroundPainter;
    }
}

