/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.widget;

import io.github.cottonmc.cotton.gui.client.ScreenDrawing;
import io.github.cottonmc.cotton.gui.impl.client.NarrationMessages;
import io.github.cottonmc.cotton.gui.impl.client.WidgetTextures;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.HorizontalAlignment;
import io.github.cottonmc.cotton.gui.widget.data.InputResult;
import io.github.cottonmc.cotton.gui.widget.icon.Icon;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3417;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_6880;
import net.minecraft.class_8666;
import org.jetbrains.annotations.Nullable;

public class WButton
extends WWidget {
    private static final int ICON_SPACING = 2;
    @Nullable
    private class_2561 label;
    protected int color = -12566464;
    protected int iconSize = 16;
    private boolean enabled = true;
    protected HorizontalAlignment alignment = HorizontalAlignment.CENTER;
    @Nullable
    private Runnable onClick;
    @Nullable
    private Icon icon = null;

    public WButton() {
    }

    public WButton(@Nullable Icon icon) {
        this.icon = icon;
    }

    public WButton(@Nullable class_2561 label) {
        this.label = label;
    }

    public WButton(@Nullable Icon icon, @Nullable class_2561 label) {
        this.icon = icon;
        this.label = label;
    }

    @Override
    public boolean canResize() {
        return true;
    }

    @Override
    public boolean canFocus() {
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void paint(class_332 context, int x, int y, int mouseX, int mouseY) {
        boolean hovered = this.isWithinBounds(mouseX, mouseY);
        class_8666 textures = WidgetTextures.getButtonTextures(this.shouldRenderInDarkMode());
        context.method_52706(class_10799.field_56883, textures.method_52729(this.enabled, hovered || this.isFocused()), x, y, this.getWidth(), this.getHeight());
        if (this.icon != null) {
            this.icon.paint(context, x + 2, y + (this.getHeight() - this.iconSize) / 2, this.iconSize);
        }
        if (this.label != null) {
            int color = -2039584;
            if (!this.enabled) {
                color = -6250336;
            }
            int xOffset = this.icon != null && this.alignment == HorizontalAlignment.LEFT ? 2 + this.iconSize + 2 : 0;
            ScreenDrawing.drawStringWithShadow(context, this.label.method_30937(), this.alignment, x + xOffset, y + (this.getHeight() - 8) / 2, this.width, color);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public InputResult onClick(class_11909 click, boolean doubled) {
        return this.onClick((int)click.comp_4798(), (int)click.comp_4799());
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public InputResult onKeyPressed(class_11908 input) {
        if (WButton.isActivationKey(input.comp_4795())) {
            return this.onClick(0, 0);
        }
        return InputResult.IGNORED;
    }

    @Environment(value=EnvType.CLIENT)
    private InputResult onClick(int x, int y) {
        if (this.enabled && this.isWithinBounds(x, y)) {
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
            if (this.onClick != null) {
                this.onClick.run();
            }
            return InputResult.PROCESSED;
        }
        return InputResult.IGNORED;
    }

    @Nullable
    public Runnable getOnClick() {
        return this.onClick;
    }

    public WButton setOnClick(@Nullable Runnable onClick) {
        this.onClick = onClick;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public WButton setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Nullable
    public class_2561 getLabel() {
        return this.label;
    }

    public WButton setLabel(class_2561 label) {
        this.label = label;
        return this;
    }

    public HorizontalAlignment getAlignment() {
        return this.alignment;
    }

    public WButton setAlignment(HorizontalAlignment alignment) {
        this.alignment = alignment;
        return this;
    }

    public int getIconSize() {
        return this.iconSize;
    }

    public WButton setIconSize(int iconSize) {
        this.iconSize = iconSize;
        return this;
    }

    @Nullable
    public Icon getIcon() {
        return this.icon;
    }

    public WButton setIcon(@Nullable Icon icon) {
        this.icon = icon;
        return this;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void addNarrations(class_6382 builder) {
        builder.method_37034(class_6381.field_33788, (class_2561)class_339.method_32602((class_2561)this.getLabel()));
        if (this.isEnabled()) {
            if (this.isFocused()) {
                builder.method_37034(class_6381.field_33791, NarrationMessages.Vanilla.BUTTON_USAGE_FOCUSED);
            } else if (this.isHovered()) {
                builder.method_37034(class_6381.field_33791, NarrationMessages.Vanilla.BUTTON_USAGE_HOVERED);
            }
        }
    }
}

