/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.client;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.cottonmc.cotton.gui.client.LibGui;
import io.github.cottonmc.cotton.gui.impl.client.CottonScreenImpl;
import io.github.cottonmc.cotton.gui.widget.data.HorizontalAlignment;
import io.github.cottonmc.cotton.gui.widget.data.Texture;
import net.minecraft.class_1159;
import net.minecraft.class_2583;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5481;
import net.minecraft.class_757;
import org.jetbrains.annotations.Nullable;

public class ScreenDrawing {
    private ScreenDrawing() {
    }

    public static void texturedRect(class_4587 matrices, int x, int y, int width, int height, class_2960 texture, int color) {
        ScreenDrawing.texturedRect(matrices, x, y, width, height, texture, 0.0f, 0.0f, 1.0f, 1.0f, color, 1.0f);
    }

    public static void texturedRect(class_4587 matrices, int x, int y, int width, int height, class_2960 texture, int color, float opacity) {
        ScreenDrawing.texturedRect(matrices, x, y, width, height, texture, 0.0f, 0.0f, 1.0f, 1.0f, color, opacity);
    }

    public static void texturedRect(class_4587 matrices, int x, int y, int width, int height, class_2960 texture, float u1, float v1, float u2, float v2, int color) {
        ScreenDrawing.texturedRect(matrices, x, y, width, height, texture, u1, v1, u2, v2, color, 1.0f);
    }

    public static void texturedRect(class_4587 matrices, int x, int y, int width, int height, Texture texture, int color) {
        ScreenDrawing.texturedRect(matrices, x, y, width, height, texture, color, 1.0f);
    }

    public static void texturedRect(class_4587 matrices, int x, int y, int width, int height, Texture texture, int color, float opacity) {
        ScreenDrawing.texturedRect(matrices, x, y, width, height, texture.image(), texture.u1(), texture.v1(), texture.u2(), texture.v2(), color, opacity);
    }

    public static void texturedRect(class_4587 matrices, int x, int y, int width, int height, class_2960 texture, float u1, float v1, float u2, float v2, int color, float opacity) {
        if (width <= 0) {
            width = 1;
        }
        if (height <= 0) {
            height = 1;
        }
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        class_1159 model = matrices.method_23760().method_23761();
        RenderSystem.enableBlend();
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)opacity);
        RenderSystem.setShader(class_757::method_34542);
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        buffer.method_22918(model, (float)x, (float)(y + height), 0.0f).method_22913(u1, v2).method_1344();
        buffer.method_22918(model, (float)(x + width), (float)(y + height), 0.0f).method_22913(u2, v2).method_1344();
        buffer.method_22918(model, (float)(x + width), (float)y, 0.0f).method_22913(u2, v1).method_1344();
        buffer.method_22918(model, (float)x, (float)y, 0.0f).method_22913(u1, v1).method_1344();
        buffer.method_1326();
        class_286.method_1309((class_287)buffer);
        RenderSystem.disableBlend();
    }

    public static void texturedGuiRect(class_4587 matrices, int x, int y, int width, int height, class_2960 texture, int textureX, int textureY, int color) {
        float px = 0.00390625f;
        ScreenDrawing.texturedRect(matrices, x, y, width, height, texture, (float)textureX * px, (float)textureY * px, (float)(textureX + width) * px, (float)(textureY + height) * px, color);
    }

    public static void texturedGuiRect(class_4587 matrices, int left, int top, int width, int height, class_2960 texture, int color) {
        ScreenDrawing.texturedGuiRect(matrices, left, top, width, height, texture, 0, 0, color);
    }

    public static void coloredRect(class_4587 matrices, int left, int top, int width, int height, int color) {
        if (width <= 0) {
            width = 1;
        }
        if (height <= 0) {
            height = 1;
        }
        class_332.method_25294((class_4587)matrices, (int)left, (int)top, (int)(left + width), (int)(top + height), (int)color);
    }

    public static void drawGuiPanel(class_4587 matrices, int x, int y, int width, int height) {
        if (LibGui.isDarkMode()) {
            ScreenDrawing.drawGuiPanel(matrices, x, y, width, height, -16053493, -13684945, -12500671, -16777216);
        } else {
            ScreenDrawing.drawGuiPanel(matrices, x, y, width, height, -11184811, -3750202, -1, -16777216);
        }
    }

    public static void drawGuiPanel(class_4587 matrices, int x, int y, int width, int height, int panelColor) {
        int shadowColor = ScreenDrawing.multiplyColor(panelColor, 0.5f);
        int hilightColor = ScreenDrawing.multiplyColor(panelColor, 1.25f);
        ScreenDrawing.drawGuiPanel(matrices, x, y, width, height, shadowColor, panelColor, hilightColor, -16777216);
    }

    public static void drawGuiPanel(class_4587 matrices, int x, int y, int width, int height, int shadow, int panel, int hilight, int outline) {
        ScreenDrawing.coloredRect(matrices, x + 3, y + 3, width - 6, height - 6, panel);
        ScreenDrawing.coloredRect(matrices, x + 2, y + 1, width - 4, 2, hilight);
        ScreenDrawing.coloredRect(matrices, x + 2, y + height - 3, width - 4, 2, shadow);
        ScreenDrawing.coloredRect(matrices, x + 1, y + 2, 2, height - 4, hilight);
        ScreenDrawing.coloredRect(matrices, x + width - 3, y + 2, 2, height - 4, shadow);
        ScreenDrawing.coloredRect(matrices, x + width - 3, y + 2, 1, 1, panel);
        ScreenDrawing.coloredRect(matrices, x + 2, y + height - 3, 1, 1, panel);
        ScreenDrawing.coloredRect(matrices, x + 3, y + 3, 1, 1, hilight);
        ScreenDrawing.coloredRect(matrices, x + width - 4, y + height - 4, 1, 1, shadow);
        ScreenDrawing.coloredRect(matrices, x + 2, y, width - 4, 1, outline);
        ScreenDrawing.coloredRect(matrices, x, y + 2, 1, height - 4, outline);
        ScreenDrawing.coloredRect(matrices, x + width - 1, y + 2, 1, height - 4, outline);
        ScreenDrawing.coloredRect(matrices, x + 2, y + height - 1, width - 4, 1, outline);
        ScreenDrawing.coloredRect(matrices, x + 1, y + 1, 1, 1, outline);
        ScreenDrawing.coloredRect(matrices, x + 1, y + height - 2, 1, 1, outline);
        ScreenDrawing.coloredRect(matrices, x + width - 2, y + 1, 1, 1, outline);
        ScreenDrawing.coloredRect(matrices, x + width - 2, y + height - 2, 1, 1, outline);
    }

    public static void drawBeveledPanel(class_4587 matrices, int x, int y) {
        ScreenDrawing.drawBeveledPanel(matrices, x, y, 18, 18, -13158601, -7631989, -1);
    }

    public static void drawBeveledPanel(class_4587 matrices, int x, int y, int width, int height) {
        ScreenDrawing.drawBeveledPanel(matrices, x, y, width, height, -13158601, -7631989, -1);
    }

    public static void drawBeveledPanel(class_4587 matrices, int x, int y, int width, int height, int topleft, int panel, int bottomright) {
        ScreenDrawing.coloredRect(matrices, x, y, width, height, panel);
        ScreenDrawing.coloredRect(matrices, x, y, width - 1, 1, topleft);
        ScreenDrawing.coloredRect(matrices, x, y + 1, 1, height - 2, topleft);
        ScreenDrawing.coloredRect(matrices, x + width - 1, y + 1, 1, height - 1, bottomright);
        ScreenDrawing.coloredRect(matrices, x + 1, y + height - 1, width - 1, 1, bottomright);
    }

    public static void drawString(class_4587 matrices, String s, HorizontalAlignment align, int x, int y, int width, int color) {
        switch (align) {
            case LEFT: {
                class_310.method_1551().field_1772.method_1729(matrices, s, (float)x, (float)y, color);
                break;
            }
            case CENTER: {
                int wid = class_310.method_1551().field_1772.method_1727(s);
                int l = width / 2 - wid / 2;
                class_310.method_1551().field_1772.method_1729(matrices, s, (float)(x + l), (float)y, color);
                break;
            }
            case RIGHT: {
                int wid = class_310.method_1551().field_1772.method_1727(s);
                int l = width - wid;
                class_310.method_1551().field_1772.method_1729(matrices, s, (float)(x + l), (float)y, color);
            }
        }
    }

    public static void drawString(class_4587 matrices, class_5481 text, HorizontalAlignment align, int x, int y, int width, int color) {
        switch (align) {
            case LEFT: {
                class_310.method_1551().field_1772.method_27528(matrices, text, (float)x, (float)y, color);
                break;
            }
            case CENTER: {
                int wid = class_310.method_1551().field_1772.method_30880(text);
                int l = width / 2 - wid / 2;
                class_310.method_1551().field_1772.method_27528(matrices, text, (float)(x + l), (float)y, color);
                break;
            }
            case RIGHT: {
                int wid = class_310.method_1551().field_1772.method_30880(text);
                int l = width - wid;
                class_310.method_1551().field_1772.method_27528(matrices, text, (float)(x + l), (float)y, color);
            }
        }
    }

    public static void drawStringWithShadow(class_4587 matrices, String s, HorizontalAlignment align, int x, int y, int width, int color) {
        switch (align) {
            case LEFT: {
                class_310.method_1551().field_1772.method_1720(matrices, s, (float)x, (float)y, color);
                break;
            }
            case CENTER: {
                int wid = class_310.method_1551().field_1772.method_1727(s);
                int l = width / 2 - wid / 2;
                class_310.method_1551().field_1772.method_1720(matrices, s, (float)(x + l), (float)y, color);
                break;
            }
            case RIGHT: {
                int wid = class_310.method_1551().field_1772.method_1727(s);
                int l = width - wid;
                class_310.method_1551().field_1772.method_1720(matrices, s, (float)(x + l), (float)y, color);
            }
        }
    }

    public static void drawStringWithShadow(class_4587 matrices, class_5481 text, HorizontalAlignment align, int x, int y, int width, int color) {
        switch (align) {
            case LEFT: {
                class_310.method_1551().field_1772.method_27517(matrices, text, (float)x, (float)y, color);
                break;
            }
            case CENTER: {
                int wid = class_310.method_1551().field_1772.method_30880(text);
                int l = width / 2 - wid / 2;
                class_310.method_1551().field_1772.method_27517(matrices, text, (float)(x + l), (float)y, color);
                break;
            }
            case RIGHT: {
                int wid = class_310.method_1551().field_1772.method_30880(text);
                int l = width - wid;
                class_310.method_1551().field_1772.method_27517(matrices, text, (float)(x + l), (float)y, color);
            }
        }
    }

    public static void drawString(class_4587 matrices, String s, int x, int y, int color) {
        class_310.method_1551().field_1772.method_1729(matrices, s, (float)x, (float)y, color);
    }

    public static void drawString(class_4587 matrices, class_5481 text, int x, int y, int color) {
        class_310.method_1551().field_1772.method_27528(matrices, text, (float)x, (float)y, color);
    }

    public static void drawTextHover(class_4587 matrices, @Nullable class_2583 textStyle, int x, int y) {
        class_437 class_4372 = class_310.method_1551().field_1755;
        if (class_4372 instanceof CottonScreenImpl) {
            CottonScreenImpl screen = (CottonScreenImpl)class_4372;
            screen.renderTextHover(matrices, textStyle, x, y);
        }
    }

    public static int colorAtOpacity(int opaque, float opacity) {
        if (opacity < 0.0f) {
            opacity = 0.0f;
        }
        if (opacity > 1.0f) {
            opacity = 1.0f;
        }
        int a = (int)(opacity * 255.0f);
        return opaque & 0xFFFFFF | a << 24;
    }

    public static int multiplyColor(int color, float amount) {
        int a = color & 0xFF000000;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        r = Math.min(r * amount, 1.0f);
        g = Math.min(g * amount, 1.0f);
        b = Math.min(b * amount, 1.0f);
        int ir = (int)(r * 255.0f);
        int ig = (int)(g * 255.0f);
        int ib = (int)(b * 255.0f);
        return a | ir << 16 | ig << 8 | ib;
    }
}

