/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.widget;

import io.github.cottonmc.cotton.gui.GuiDescription;
import io.github.cottonmc.cotton.gui.client.ScreenDrawing;
import io.github.cottonmc.cotton.gui.widget.TooltipBuilder;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.Texture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3913;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;

public class WBar
extends WWidget {
    @Nullable
    protected final Texture bg;
    @Nullable
    protected final Texture bar;
    protected final int field;
    protected final int max;
    protected int maxValue;
    protected class_3913 properties;
    private boolean manuallySetProperties = false;
    protected final Direction direction;
    protected String tooltipLabel;
    protected class_2561 tooltipTextComponent;

    public WBar(@Nullable Texture bg, @Nullable Texture bar, int field, int maxField) {
        this(bg, bar, field, maxField, Direction.UP);
    }

    public WBar(@Nullable Texture bg, @Nullable Texture bar, int field, int maxField, Direction dir) {
        this.bg = bg;
        this.bar = bar;
        this.field = field;
        this.max = maxField;
        this.maxValue = 0;
        this.direction = dir;
    }

    public WBar(class_2960 bg, class_2960 bar, int field, int maxField) {
        this(bg, bar, field, maxField, Direction.UP);
    }

    public WBar(class_2960 bg, class_2960 bar, int field, int maxField, Direction dir) {
        this(new Texture(bg), new Texture(bar), field, maxField, dir);
    }

    public WBar withTooltip(String label) {
        this.tooltipLabel = label;
        return this;
    }

    public WBar withTooltip(class_2561 label) {
        this.tooltipTextComponent = label;
        return this;
    }

    @Override
    public boolean canResize() {
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void paint(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
        int barSize;
        if (this.bg != null) {
            ScreenDrawing.texturedRect(matrices, x, y, this.getWidth(), this.getHeight(), this.bg, -1);
        } else {
            ScreenDrawing.coloredRect(matrices, x, y, this.getWidth(), this.getHeight(), ScreenDrawing.colorAtOpacity(0, 0.25f));
        }
        int maxVal = this.max >= 0 ? this.properties.method_17390(this.max) : this.maxValue;
        float percent = (float)this.properties.method_17390(this.field) / (float)maxVal;
        if (percent < 0.0f) {
            percent = 0.0f;
        }
        if (percent > 1.0f) {
            percent = 1.0f;
        }
        int barMax = this.getWidth();
        if (this.direction == Direction.DOWN || this.direction == Direction.UP) {
            barMax = this.getHeight();
        }
        if ((barSize = (int)((float)barMax * (percent = (float)((int)(percent * (float)barMax)) / (float)barMax))) <= 0) {
            return;
        }
        switch (this.direction.ordinal()) {
            case 0: {
                int left = x;
                int top = y + this.getHeight();
                top -= barSize;
                if (this.bar != null) {
                    ScreenDrawing.texturedRect(matrices, left, top, this.getWidth(), barSize, this.bar.image(), this.bar.u1(), class_3532.method_16439((float)percent, (float)this.bar.v2(), (float)this.bar.v1()), this.bar.u2(), this.bar.v2(), -1);
                    break;
                }
                ScreenDrawing.coloredRect(matrices, left, top, this.getWidth(), barSize, ScreenDrawing.colorAtOpacity(0xFFFFFF, 0.5f));
                break;
            }
            case 1: {
                if (this.bar != null) {
                    ScreenDrawing.texturedRect(matrices, x, y, barSize, this.getHeight(), this.bar.image(), this.bar.u1(), this.bar.v1(), class_3532.method_16439((float)percent, (float)this.bar.u1(), (float)this.bar.u2()), this.bar.v2(), -1);
                    break;
                }
                ScreenDrawing.coloredRect(matrices, x, y, barSize, this.getHeight(), ScreenDrawing.colorAtOpacity(0xFFFFFF, 0.5f));
                break;
            }
            case 2: {
                if (this.bar != null) {
                    ScreenDrawing.texturedRect(matrices, x, y, this.getWidth(), barSize, this.bar.image(), this.bar.u1(), this.bar.v1(), this.bar.u2(), class_3532.method_16439((float)percent, (float)this.bar.v1(), (float)this.bar.v2()), -1);
                    break;
                }
                ScreenDrawing.coloredRect(matrices, x, y, this.getWidth(), barSize, ScreenDrawing.colorAtOpacity(0xFFFFFF, 0.5f));
                break;
            }
            case 3: {
                int left = x + this.getWidth();
                int top = y;
                left -= barSize;
                if (this.bar != null) {
                    ScreenDrawing.texturedRect(matrices, left, top, barSize, this.getHeight(), this.bar.image(), class_3532.method_16439((float)percent, (float)this.bar.u2(), (float)this.bar.u1()), this.bar.v1(), this.bar.u2(), this.bar.v2(), -1);
                    break;
                }
                ScreenDrawing.coloredRect(matrices, left, top, barSize, this.getHeight(), ScreenDrawing.colorAtOpacity(0xFFFFFF, 0.5f));
            }
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void addTooltip(TooltipBuilder information) {
        if (this.tooltipLabel != null) {
            int value = this.field >= 0 ? this.properties.method_17390(this.field) : 0;
            int valMax = this.max >= 0 ? this.properties.method_17390(this.max) : this.maxValue;
            information.add(new class_2561[]{new class_2588(this.tooltipLabel, new Object[]{value, valMax})});
        }
        if (this.tooltipTextComponent != null) {
            try {
                information.add(this.tooltipTextComponent);
            }
            catch (Throwable t) {
                information.add(new class_2561[]{new class_2585(t.getLocalizedMessage())});
            }
        }
    }

    @Override
    public void validate(GuiDescription host) {
        super.validate(host);
        if (this.properties == null || !this.manuallySetProperties) {
            this.properties = host.getPropertyDelegate();
        }
    }

    @Nullable
    public class_3913 getProperties() {
        return this.properties;
    }

    public WBar setProperties(class_3913 properties) {
        this.properties = properties;
        this.manuallySetProperties = properties != null;
        return this;
    }

    public static WBar withConstantMaximum(class_2960 bg, class_2960 bar, int field, int maxValue, Direction dir) {
        WBar result = new WBar(bg, bar, field, -1, dir);
        result.maxValue = maxValue;
        return result;
    }

    public static WBar withConstantMaximum(Texture bg, Texture bar, int field, int maxValue, Direction dir) {
        WBar result = new WBar(bg, bar, field, -1, dir);
        result.maxValue = maxValue;
        return result;
    }

    public static enum Direction {
        UP,
        RIGHT,
        DOWN,
        LEFT;

    }
}

