/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.widget;

import io.github.cottonmc.cotton.gui.client.ScreenDrawing;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.Texture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_4587;

public class WSprite
extends WWidget {
    protected int currentFrame = 0;
    protected long currentFrameTime = 0L;
    protected Texture[] frames;
    protected int frameTime;
    protected long lastFrame;
    protected boolean singleImage = false;
    protected int tint = -1;

    public WSprite(Texture texture) {
        this.frames = new Texture[]{texture};
        this.singleImage = true;
    }

    public WSprite(class_2960 image) {
        this(new Texture(image));
    }

    public WSprite(class_2960 image, float u1, float v1, float u2, float v2) {
        this(new Texture(image, u1, v1, u2, v2));
    }

    public WSprite(int frameTime, class_2960 ... frames) {
        this.frameTime = frameTime;
        this.frames = new Texture[frames.length];
        for (int i = 0; i < frames.length; ++i) {
            this.frames[i] = new Texture(frames[i]);
        }
        if (frames.length == 1) {
            this.singleImage = true;
        }
    }

    public WSprite(int frameTime, Texture ... frames) {
        this.frameTime = frameTime;
        this.frames = frames;
        if (frames.length == 1) {
            this.singleImage = true;
        }
    }

    public WSprite setImage(class_2960 image) {
        return this.setImage(new Texture(image));
    }

    public WSprite setFrames(class_2960 ... frames) {
        Texture[] textures = new Texture[frames.length];
        for (int i = 0; i < frames.length; ++i) {
            textures[i] = new Texture(frames[i]);
        }
        return this.setFrames(textures);
    }

    public WSprite setImage(Texture image) {
        this.frames = new Texture[]{image};
        this.singleImage = true;
        this.currentFrame = 0;
        this.currentFrameTime = 0L;
        return this;
    }

    public WSprite setFrames(Texture ... frames) {
        this.frames = frames;
        if (frames.length == 1) {
            this.singleImage = true;
        }
        if (this.currentFrame >= frames.length) {
            this.currentFrame = 0;
            this.currentFrameTime = 0L;
        }
        return this;
    }

    public WSprite setTint(int tint) {
        this.tint = tint;
        return this;
    }

    public WSprite setOpaqueTint(int tint) {
        this.tint = tint | 0xFF000000;
        return this;
    }

    public WSprite setUv(float u1, float v1, float u2, float v2) {
        Texture[] newFrames = new Texture[this.frames.length];
        for (int i = 0; i < this.frames.length; ++i) {
            newFrames[i] = this.frames[i].withUv(u1, v1, u2, v2);
        }
        return this.setFrames(newFrames);
    }

    @Override
    public boolean canResize() {
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void paint(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
        if (this.singleImage) {
            this.paintFrame(matrices, x, y, this.frames[0]);
        } else {
            boolean inBounds;
            long now = System.nanoTime() / 1000000L;
            boolean bl = inBounds = this.currentFrame >= 0 && this.currentFrame < this.frames.length;
            if (!inBounds) {
                this.currentFrame = 0;
            }
            Texture currentFrameTex = this.frames[this.currentFrame];
            this.paintFrame(matrices, x, y, currentFrameTex);
            long elapsed = now - this.lastFrame;
            this.currentFrameTime += elapsed;
            if (this.currentFrameTime >= (long)this.frameTime) {
                ++this.currentFrame;
                if (this.currentFrame >= this.frames.length - 1) {
                    this.currentFrame = 0;
                }
                this.currentFrameTime = 0L;
            }
            this.lastFrame = now;
        }
    }

    @Environment(value=EnvType.CLIENT)
    protected void paintFrame(class_4587 matrices, int x, int y, Texture texture) {
        ScreenDrawing.texturedRect(matrices, x, y, this.getWidth(), this.getHeight(), texture, this.tint);
    }
}

