/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.widget;

import io.github.cottonmc.cotton.gui.GuiDescription;
import io.github.cottonmc.cotton.gui.impl.VisualLogger;
import io.github.cottonmc.cotton.gui.widget.TooltipBuilder;
import io.github.cottonmc.cotton.gui.widget.WPanel;
import io.github.cottonmc.cotton.gui.widget.data.InputResult;
import io.github.cottonmc.cotton.gui.widget.data.ObservableProperty;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_6382;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class WWidget {
    private static final VisualLogger LOGGER = new VisualLogger(WWidget.class);
    @Nullable
    protected WPanel parent;
    protected int x = 0;
    protected int y = 0;
    protected int width = 18;
    protected int height = 18;
    @Nullable
    protected GuiDescription host;
    private final ObservableProperty<Boolean> hovered = ObservableProperty.of(false).nonnull().name("WWidget.hovered").build();

    public void setLocation(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setSize(int x, int y) {
        this.width = x;
        this.height = y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getAbsoluteX() {
        if (this.parent == null) {
            return this.getX();
        }
        return this.getX() + this.parent.getAbsoluteX();
    }

    public int getAbsoluteY() {
        if (this.parent == null) {
            return this.getY();
        }
        return this.getY() + this.parent.getAbsoluteY();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean canResize() {
        return false;
    }

    @Nullable
    public WPanel getParent() {
        return this.parent;
    }

    public void setParent(WPanel parent) {
        this.parent = parent;
    }

    @Environment(value=EnvType.CLIENT)
    public InputResult onMouseDown(int x, int y, int button) {
        return InputResult.IGNORED;
    }

    @Environment(value=EnvType.CLIENT)
    public InputResult onMouseDrag(int x, int y, int button, double deltaX, double deltaY) {
        return InputResult.IGNORED;
    }

    @Environment(value=EnvType.CLIENT)
    public InputResult onMouseUp(int x, int y, int button) {
        return InputResult.IGNORED;
    }

    @Environment(value=EnvType.CLIENT)
    public InputResult onClick(int x, int y, int button) {
        return InputResult.IGNORED;
    }

    @Environment(value=EnvType.CLIENT)
    public InputResult onMouseScroll(int x, int y, double amount) {
        return InputResult.IGNORED;
    }

    @Environment(value=EnvType.CLIENT)
    public InputResult onMouseMove(int x, int y) {
        return InputResult.IGNORED;
    }

    @Environment(value=EnvType.CLIENT)
    public void onCharTyped(char ch) {
    }

    @Environment(value=EnvType.CLIENT)
    public void onKeyPressed(int ch, int key, int modifiers) {
    }

    @Environment(value=EnvType.CLIENT)
    public void onKeyReleased(int ch, int key, int modifiers) {
    }

    public void onFocusGained() {
    }

    public void onFocusLost() {
    }

    public boolean isFocused() {
        if (this.host == null) {
            return false;
        }
        return this.host.isFocused(this);
    }

    public void requestFocus() {
        if (this.host != null) {
            this.host.requestFocus(this);
        } else {
            LOGGER.warn("Requesting focus for {}, but the host is null", this);
        }
    }

    public void releaseFocus() {
        if (this.host != null) {
            this.host.releaseFocus(this);
        }
    }

    public boolean canFocus() {
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public void paint(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
    }

    public boolean isWithinBounds(int x, int y) {
        return x >= 0 && y >= 0 && x < this.width && y < this.height;
    }

    @Environment(value=EnvType.CLIENT)
    public void renderTooltip(class_4587 matrices, int x, int y, int tX, int tY) {
        TooltipBuilder builder = new TooltipBuilder();
        this.addTooltip(builder);
        if (builder.size() == 0) {
            return;
        }
        class_437 screen = class_310.method_1551().field_1755;
        screen.method_25417(matrices, builder.lines, tX + x, tY + y);
    }

    public void validate(GuiDescription host) {
        if (host != null) {
            this.host = host;
        } else {
            LOGGER.warn("Validating {} with a null host", this);
        }
    }

    @Nullable
    public final GuiDescription getHost() {
        return this.host;
    }

    public void setHost(@Nullable GuiDescription host) {
        this.host = host;
    }

    @Environment(value=EnvType.CLIENT)
    public void addTooltip(TooltipBuilder tooltip) {
    }

    public WWidget hit(int x, int y) {
        return this;
    }

    @Environment(value=EnvType.CLIENT)
    public void tick() {
    }

    @Nullable
    public WWidget cycleFocus(boolean lookForwards) {
        return this.canFocus() ? (this.isFocused() ? null : this) : null;
    }

    public void onShown() {
    }

    public void onHidden() {
        this.releaseFocus();
    }

    @Environment(value=EnvType.CLIENT)
    public void addPainters() {
    }

    public boolean canHover() {
        return true;
    }

    @ApiStatus.Experimental
    public ObservableProperty<Boolean> hoveredProperty() {
        return this.hovered;
    }

    @ApiStatus.Experimental
    public final boolean isHovered() {
        return this.hoveredProperty().get();
    }

    @ApiStatus.Experimental
    public final void setHovered(boolean hovered) {
        this.hoveredProperty().set(hovered);
    }

    public boolean isNarratable() {
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public void addNarrations(class_6382 builder) {
    }

    @Environment(value=EnvType.CLIENT)
    public static boolean isActivationKey(int ch) {
        return ch == 257 || ch == 335 || ch == 32;
    }
}

